/*H**************************************************************************
* NAME:         config.h         
*----------------------------------------------------------------------------
* Copyright (c) 2003 Atmel.
*----------------------------------------------------------------------------
* RELEASE:      c5131-usb-kbd-light-1_0_2      
* FILE_REV:     1.5.2.5     
*----------------------------------------------------------------------------
* PURPOSE: 
* Describes the system dependant software configuration.
* This file is included by all source files in order to access to system wide
* configuration.
*****************************************************************************/

#ifndef _CONFIG_H_
#define _CONFIG_H_

/*_____ I N C L U D E S ____________________________________________________*/


#include "lib_mcu/compiler.h"
#include "lib_mcu/reg_5131.h"
#include "lib_mcu/ext_5131.h"
#include "lib_mcu/5131_drv.h"

/*_____ M A C R O S ________________________________________________________*/


/*_____ D E F I N I T I O N ________________________________________________*/

// Board config
#define FOSC                    24000
#define FILE_BOARD_H            "lib_board/c5131_evab.h"
#define CPUB_VERSION            0x0102

#define TWI_SCAL                120 //120, 160, 60 //dont work with 256, 224, 192, 960
#define SDA_SOFT                GENEB_SDA
#define SCL_SOFT                GENEB_SCL

//#define USE_STATIC_OUTPUT       // static output are faster but cannot be desactivated
#define ENABLE_SPLASH_SCREEN      // Splash screen is first screen show after reset
#define LOGO_ATMEL                // ASCII art of Logo ATMEL



/*_____ D E F I N I T I O N ________________________________________________*/
/* Scheduler Definitions */
#define Scheduler_time_init     init_soft_timers	// declare function " init_soft_timers " 
													// so, Body of function stay in " timer_soft.c "

#define Scheduler_task_1_init   usb_task_init		// Body of function stay in " usb_task.c "


#define Scheduler_task_1        usb_task			// Body of function stay in " usb_task.c "(142)
#define Scheduler_task_2        usb_kbd_task		// Body of function stay in " usb_task.c "(206)

#define SCHEDULER_TYPE          SCHEDULER_FREE  	// SCHEDULER_(TIMED|TASK|FREE|CUSTOM)

/* USB Configuration */
                                    /* DEVICE DESCRIPTOR */
#define USB_SPECIFICATION     0x1001
#define DEVICE_CLASS          0
#define DEVICE_SUB_CLASS      0
#define DEVICE_PROTOCOL       0
#define EP_CONTROL_LENGTH     32
#define VENDOR_ID             0xEB03        /* Atmel vendor ID = 03EBh */
#define PRODUCT_ID            0x0320        /* Product ID: 2003h = HID keyboard */
#define RELEASE_NUMBER        0x0001
#define MAN_INDEX             0x01
#define PROD_INDEX            0x02
#define SN_INDEX              0x03
#define NB_CONFIGURATION      1

                                    /* CONFIGURATION DESCRIPTOR */
#define CONF_LENGTH           0x2200
#define NB_INTERFACE          1
#define CONF_NB               1
#define CONF_INDEX            0
#define CONF_ATTRIBUTES       USB_CONFIG_BUSPOWERED
#define MAX_POWER             50          /* 100 mA */
                                    /* INTERFACE DESCRIPTOR */
#define INTERFACE_NB          0
#define ALTERNATE             0
#define NB_ENDPOINT           1
#define INTERFACE_CLASS       0x03
#define INTERFACE_SUB_CLASS   0
#define INTERFACE_PROTOCOL    0
#define INTERFACE_INDEX       0
                                    /* ENDPOINT 1 DESCRIPTOR */
#define ENDPOINT_NB_1         ENDPOINT_1
#define EP_ATTRIBUTES_1       0x03
#define EP_SIZE_1             ((Uint16)EP_IN_LENGTH) << 8 
#define EP_INTERVAL_1         0x20
                                    /* REPORT DESCRIPTOR */
#define SIZE_OF_REPORT        0x3B


#define USB_MANUFACTURER_NAME {'A'<<8, 'T'<<8, 'M'<<8, 'E'<<8, 'L'<<8}
#define USB_MN_LENGTH         5
#define USB_PRODUCT_NAME      {'A'<<8, 'T'<<8, '8'<<8, '9'<<8, 'C'<<8, '5'<<8, '1'<<8, \
                               '3'<<8, '1'<<8, ' '<<8, \
                               'E'<<8, 'v'<<8, 'a'<<8, 'B'<<8, ' '<<8, \
                               'H'<<8, 'I'<<8, 'D'<<8, ' '<<8, \
                               'K'<<8, 'e'<<8, 'y'<<8, 'b'<<8, 'o'<<8, 'a'<<8, 'r'<<8,'d'<<8}
#define USB_PN_LENGTH         27
#define USB_SERIAL_NUMBER     {'1'<<8, '.'<<8, '0'<<8, '.'<<8, '0'<<8}
#define USB_SN_LENGTH         5

#define LANG_ID               0x00
#define LANGUAGE_ID           0x0904

#define EP_CONTROL            0x00
#define EP_IN                 0x01
#define EP_KBD_IN             EP_IN
#define EP_IN_LENGTH          8
#define ENDPOINT_0            0x00
#define ENDPOINT_1            0x81

/*_____ D E C L A R A T I O N ______________________________________________*/


#endif /* _CONFIG_H_ */
